/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWField;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWWorkElement;
import filenet.vw.api.VWXMLData;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.api.VWXMLUtil;
import filenet.vw.server.VWFieldUtility;
import java.util.Date;

public final class VWParameter
implements IVWField {
    protected int fieldType = 0;
    protected String name = null;
    protected String description = null;
    protected int mode = 0;
    protected Object value = null;
    protected boolean isArray = false;
    protected boolean isSystemParameter = false;
    protected VWWorkElement workElement = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-04 00:20:14 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/4 $";
    }

    protected VWParameter(String theName, int theMode, int theFieldType, boolean array, boolean theSystemParameter, String thePrompt, VWWorkElement theWorkElement) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWParameterBadName", "Parameter name cannot be null or empty");
        }
        if (!VWModeType.isValid(theMode)) {
            throw new VWException("vw.api.VWParameterInvalidModeType", "theMode is not a valid mode type");
        }
        if (!VWFieldType.isValid(theFieldType)) {
            throw new VWException("vw.api.VWParameterInvalidFieldType", "theFieldType is not a valid field type");
        }
        if (theWorkElement == null) {
            throw new VWException("vw.api.VWParameterInvalidWorkElement", "The work element value cannot be null.  This parameter must be associated with either a VWStepElement or VWWorkObject.");
        }
        this.name = theName;
        this.mode = theMode;
        this.fieldType = theFieldType;
        this.isArray = array;
        this.isSystemParameter = theSystemParameter;
        this.description = thePrompt;
        this.workElement = theWorkElement;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public String getName() {
        if (this.workElement != null) {
            return this.workElement.translateStr(this.name);
        }
        return this.name;
    }

    public String getAuthoredName() throws VWException {
        if (this.workElement != null) {
            return this.workElement.authorStr(this.name);
        }
        return this.name;
    }

    public int getMode() {
        return this.mode;
    }

    public String getDescription() throws VWException {
        if (this.workElement != null) {
            return this.workElement.translateStr(this.description);
        }
        return this.description;
    }

    public Object getValue() throws VWException {
        if (this.value == null) {
            return null;
        }
        switch (this.fieldType) {
            case 1: {
                if (this.isArray) {
                    Integer[] theArray = new Integer[((Object[])this.value).length];
                    System.arraycopy((Object[])this.value, 0, theArray, 0, theArray.length);
                    return theArray;
                }
                return (Integer)this.value;
            }
            case 2: {
                if (this.isArray) {
                    String[] theArray = new String[((Object[])this.value).length];
                    System.arraycopy((Object[])this.value, 0, theArray, 0, theArray.length);
                    return theArray;
                }
                return (String)this.value;
            }
            case 4: {
                if (this.isArray) {
                    Boolean[] theArray = new Boolean[((Object[])this.value).length];
                    System.arraycopy((Object[])this.value, 0, theArray, 0, theArray.length);
                    return theArray;
                }
                return (Boolean)this.value;
            }
            case 8: {
                if (this.isArray) {
                    Double[] theArray = new Double[((Object[])this.value).length];
                    System.arraycopy((Object[])this.value, 0, theArray, 0, theArray.length);
                    return theArray;
                }
                return (Double)this.value;
            }
            case 16: 
            case 256: {
                if (this.isArray) {
                    Date[] theArray = new Date[((Object[])this.value).length];
                    System.arraycopy((Object[])this.value, 0, theArray, 0, theArray.length);
                    return theArray;
                }
                return (Date)this.value;
            }
            case 32: {
                if (this.isArray) {
                    if (this.value instanceof VWAttachment[]) {
                        return this.value;
                    }
                    Object[] strs = null;
                    if (this.value instanceof Object[]) {
                        strs = (Object[])this.value;
                    }
                    if (strs == null || strs.length < 1) {
                        return null;
                    }
                    VWAttachment[] theArray = new VWAttachment[strs.length];
                    for (int i = 0; i < strs.length; ++i) {
                        theArray[i] = strs[i] != null ? new VWAttachment((String)strs[i]) : null;
                    }
                    return theArray;
                }
                if (this.value instanceof VWAttachment) {
                    return this.value;
                }
                VWAttachment newAttachment = null;
                if (this.value != null && this.value instanceof String) {
                    newAttachment = new VWAttachment((String)this.value);
                }
                return newAttachment;
            }
            case 64: {
                if (this.isArray) {
                    VWParticipant[] theArray = null;
                    Object[] arrayOfObject = null;
                    if (this.value instanceof Object[]) {
                        arrayOfObject = (Object[])this.value;
                    }
                    if (arrayOfObject == null || arrayOfObject.length < 1) {
                        theArray = new VWParticipant[]{new VWParticipant("")};
                        return theArray;
                    }
                    theArray = new VWParticipant[arrayOfObject.length];
                    for (int i = 0; i < arrayOfObject.length; ++i) {
                        if (arrayOfObject[i] != null) {
                            theArray[i] = arrayOfObject[i] instanceof VWParticipant ? (VWParticipant)arrayOfObject[i] : new VWParticipant(arrayOfObject[i].toString());
                            theArray[i].setCommandSession(this.workElement.getSession());
                            continue;
                        }
                        theArray[i] = new VWParticipant("");
                    }
                    return theArray;
                }
                if (this.value instanceof VWParticipant) {
                    return this.value;
                }
                VWParticipant newParticipant = null;
                if (this.value != null && this.value instanceof String) {
                    newParticipant = new VWParticipant((String)this.value);
                    newParticipant.setCommandSession(this.workElement.getSession());
                }
                return newParticipant;
            }
            case 128: {
                if (this.isArray) {
                    if (this.value instanceof VWXMLData[]) {
                        return this.value;
                    }
                    Object[] strs = null;
                    if (this.value instanceof Object[]) {
                        strs = (Object[])this.value;
                    }
                    if (strs == null || strs.length < 1) {
                        return null;
                    }
                    VWXMLData[] theArray = new VWXMLData[strs.length];
                    for (int i = 0; i < strs.length; ++i) {
                        theArray[i] = strs[i] != null ? new VWXMLData((String)strs[i], null, null, true) : null;
                    }
                    return theArray;
                }
                if (this.value instanceof VWXMLData) {
                    return this.value;
                }
                VWXMLData newXML = null;
                if (this.value != null && this.value instanceof String) {
                    newXML = new VWXMLData((String)this.value, null, null, true);
                }
                return newXML;
            }
            case 512: {
                if (this.isArray) {
                    if (this.value instanceof VWGuid[]) {
                        return this.value;
                    }
                    Object[] strs = null;
                    if (this.value instanceof Object[]) {
                        strs = (Object[])this.value;
                    }
                    if (strs == null || strs.length < 1) {
                        return null;
                    }
                    VWGuid[] theArray = new VWGuid[strs.length];
                    for (int i = 0; i < strs.length; ++i) {
                        theArray[i] = strs[i] != null ? new VWGuid((String)strs[i]) : null;
                    }
                    return theArray;
                }
                if (this.value instanceof VWGuid) {
                    return this.value;
                }
                VWGuid newGuid = null;
                if (this.value != null && this.value instanceof String) {
                    newGuid = new VWGuid((String)this.value);
                }
                return newGuid;
            }
        }
        return null;
    }

    protected void internalSetValue(Object newValue) throws VWException {
        this.value = newValue;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isSystemParameter() {
        return this.isSystemParameter;
    }

    public void setValue(Object theValue) throws VWException {
        if (this.mode == 1) {
            throw new VWException("vw.api.VWParameterCannotSetIn", "Cannot set this value.  The mode for this parameter is set to IN.");
        }
        theValue = VWFieldUtility.convertFieldValue(theValue, this.fieldType, this.name, this.isArray);
        this.internalSetValue(theValue);
    }

    public String getStringValue() {
        return this.toString();
    }

    public String toString() {
        if (this.value != null) {
            if (this.isArray) {
                try {
                    return VWArrayHandler.runtimeConvertArrayToString(this.value);
                }
                catch (Exception e) {
                    return "Error converting array value to string";
                }
            }
            return this.value.toString();
        }
        return null;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String INDENT_0 = "\t";
        String INDENT_1 = INDENT_0 + "\t";
        String INDENT_2 = INDENT_1 + "\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWParameterNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append(INDENT_0 + "<" + "Parameter" + "\n");
        theBuffer.append(INDENT_1 + "Name" + "=\"" + VWXMLHandler.toXMLString(this.getName()) + "\"\n");
        theBuffer.append(INDENT_1 + "AuthoredName" + "=\"" + VWXMLHandler.toXMLString(this.name) + "\"\n");
        if (this.description != null) {
            theBuffer.append(INDENT_1 + "Description" + "=\"" + VWXMLHandler.toXMLString(this.getDescription()) + "\"\n");
        }
        theBuffer.append(INDENT_1 + "Type" + "=\"" + VWFieldType.typeToString(this.fieldType) + "\"\n");
        theBuffer.append(INDENT_1 + "IsSystemParameter" + "=\"" + VWXMLHandler.booleanToString(this.isSystemParameter) + "\"\n");
        theBuffer.append(INDENT_1 + "Mode" + "=\"" + VWModeType.typeToString(this.mode) + "\"\n");
        theBuffer.append(INDENT_1 + "IsArray" + "=\"" + VWXMLHandler.booleanToString(this.isArray) + "\"");
        theBuffer.append(">");
        switch (this.fieldType) {
            case 32: {
                theBuffer.append("\n" + INDENT_1 + "<" + "Attachments");
                if (this.value != null) {
                    theBuffer.append(">\n");
                    VWAttachment tmpA = null;
                    if (!this.isArray) {
                        if (this.value instanceof VWAttachment) {
                            ((VWAttachment)this.value).toXML(theBuffer);
                        } else {
                            tmpA = new VWAttachment();
                            tmpA.setValue((String)this.value);
                            tmpA.toXML(theBuffer);
                        }
                    } else {
                        int arrayCount = ((Object[])this.value).length;
                        if (this.value instanceof VWAttachment[]) {
                            for (int i = 0; i < arrayCount; ++i) {
                                ((VWAttachment[])this.value)[i].toXML(theBuffer);
                            }
                        } else {
                            for (int i = 0; i < arrayCount; ++i) {
                                tmpA = new VWAttachment();
                                tmpA.setValue((String)((Object[])this.value)[i]);
                                tmpA.toXML(theBuffer);
                            }
                        }
                    }
                    theBuffer.append(INDENT_1 + "</" + "Attachments" + ">");
                    break;
                }
                theBuffer.append("/>");
                break;
            }
            case 64: {
                theBuffer.append("\n" + INDENT_1 + "<" + "Values");
                if (this.value != null) {
                    theBuffer.append(">");
                    int arrayCount = ((Object[])this.value).length;
                    for (int i = 0; i < arrayCount; ++i) {
                        theBuffer.append("\n");
                        if (((Object[])this.value)[i] != null) {
                            if (((Object[])this.value)[i] instanceof VWParticipant) {
                                VWParticipant tmpPar = (VWParticipant)((Object[])this.value)[i];
                                tmpPar.setCommandSession(this.workElement.getSession());
                                tmpPar.toXML(theBuffer, INDENT_2);
                                continue;
                            }
                            theBuffer.append(INDENT_2 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(((Object[])this.value)[i].toString()) + "</" + "Value" + ">\n");
                            continue;
                        }
                        theBuffer.append(INDENT_2 + "<" + "Value" + "/>\n");
                    }
                    theBuffer.append("\n" + INDENT_1 + "</" + "Values" + ">");
                    break;
                }
                theBuffer.append("/>");
                break;
            }
            default: {
                theBuffer.append("\n" + INDENT_1 + "<" + "Values");
                if (this.value != null) {
                    theBuffer.append(">");
                    if (!this.isArray) {
                        if (this.value instanceof Date) {
                            theBuffer.append("\n" + INDENT_2 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(VWXMLUtil.convertDateToUTCString((Date)this.value)) + "</" + "Value" + ">");
                        } else {
                            theBuffer.append("\n" + INDENT_2 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(this.value.toString()) + "</" + "Value" + ">");
                        }
                    } else {
                        int arrayCount = ((Object[])this.value).length;
                        for (int i = 0; i < arrayCount; ++i) {
                            if (((Object[])this.value)[i] instanceof Date) {
                                theBuffer.append("\n" + INDENT_2 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(VWXMLUtil.convertDateToUTCString((Date)((Object[])this.value)[i])) + "</" + "Value" + ">");
                                continue;
                            }
                            theBuffer.append("\n" + INDENT_2 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(((Object[])this.value)[i].toString()) + "</" + "Value" + ">");
                        }
                    }
                    theBuffer.append("\n" + INDENT_1 + "</" + "Values" + ">");
                    break;
                }
                theBuffer.append("/>");
            }
        }
        theBuffer.append("\n" + INDENT_0 + "</" + "Parameter" + ">\n");
    }
}

